from fractions import Fraction
from math import gcd
import sys

#sys.set_int_max_str_digits(1000000)

t = int(input())

if t == 2:
    print(4862378745380642626737318101484977637219057323564658907686653339599714454790559130946320953938197181210525554039710122136086190642013402927952831079021210585653078786813279351784906397934209)
    print(269103113846520710198086599018316928810831097261381335767926880507079911347095440987749703663156874995907158014866846058485318408629957749519665987782327830143454337518378955846463785600977)
    print(221855981602380704196804518854316541759883857932028285581812549404634844243737502744011549757448453135493556098964216532950604590733853450272184987603430882682754171300742698179931849310347)
else:
    N = t ** 2 + t + 4

    # Transform to elliptic curve of the form y^2 = x^3 + Ax^2 + Bx
    A = 4 * N ** 2 + 12 * N - 3
    B = 32 * (N + 3)

    # Initialize to pre-determined initial rational point on the egg
    x = Fraction(-4 * (t ** 2 + t + 1) ** 2, 1)
    y = Fraction(4 * (2 * t + 1) * (t ** 2 + t + 1) * (3 * t ** 2 + 3 * t + 7), 1)

    a_hom = 8 * (N + 3) - x + y
    b_hom = a_hom - 2 * y
    c_hom = -8 * (N + 3) - 2 * (N + 2) * x

    # Iterate nP until a positive point is found, which will happen as we are on the egg
    x_cur = x
    y_cur = y

    # First, calculate 2P by tangent line construction. Note that P never yields a positive solution.
    lm = (3 * x_cur ** 2 + 2 * A * x_cur + B) / (2 * y_cur)
    nu = (-1 * x_cur ** 3 + B * x_cur) / (2 * y_cur)

    x_cur = lm ** 2 - A - 2 * x_cur
    y_cur = -lm * x_cur - nu         # Using updated x_cur value!

    # Now loop until a positive correspondence is found
    i = 2
    while True:
        a_hom = 8 * (N + 3) - x_cur + y_cur
        b_hom = a_hom - 2 * y_cur
        c_hom = -8 * (N + 3) - 2 * (N + 2) * x_cur
        # Check if corresponds to a positive integer solution
        if a_hom > 0 and b_hom > 0 and c_hom > 0:
            # Convert to integers by multiplying by some suitable integer
            g = a_hom.denominator * b_hom.denominator // gcd(a_hom.denominator, b_hom.denominator)
            g = g * c_hom.denominator // gcd(g, c_hom.denominator)
            a = int(a_hom * g)
            b = int(b_hom * g)
            c = int(c_hom * g)
            f = gcd(gcd(a, b), c)
            a //= f
            b //= f
            c //= f
            print(a)
            print(b)
            print(c)
            break
        # Else, add another P
        lm = (y_cur - y) / (x_cur - x)
        nu = (y * x_cur - y_cur * x) / (x_cur - x)

        x_cur = lm ** 2 - A - x - x_cur
        y_cur = -lm * x_cur - nu         # Using updated x_cur value!
        i += 1
